<?php
/**
 * Upload Template
 */
?>
<div class="wrap photoweb-upload">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="photoweb-card">
        <div class="photoweb-card-header">
            <h2><span class="dashicons dashicons-cloud-upload"></span> Upload Images</h2>
        </div>
        
        <div class="photoweb-card-body">
            <form id="photoweb-upload-form" enctype="multipart/form-data">
                <div class="photoweb-form-group">
                    <label for="upload-folder">Destination Folder (Optional)</label>
                    <select id="upload-folder" name="folder_id" class="photoweb-input">
                        <option value="">Default Folder</option>
                    </select>
                    <p class="description">Select a folder to organize your images</p>
                </div>
                
                <div class="photoweb-form-group">
                    <label for="upload-images">Select Images</label>
                    <label for="upload-images" class="photoweb-upload-area" id="photoweb-upload-area">
                        <input type="file" id="upload-images" name="images[]" multiple accept="image/*" style="display: none;">
                        <div class="photoweb-upload-placeholder">
                            <span class="dashicons dashicons-cloud"></span>
                            <p>Click to select images or drag and drop</p>
                            <p class="description">Supports: JPG, PNG, GIF, WebP (Max 10MB per image)</p>
                        </div>
                    </label>
                    <div class="photoweb-compression-options" style="margin-top: 10px;">
                        <label>
                            <input type="checkbox" id="photoweb-enable-compression">
                            <span>Compress images before upload (reduces file size, maintains quality)</span>
                        </label>
                        <div id="photoweb-compression-settings" style="margin-top: 10px; margin-left: 24px; display: none;">
                            <label for="photoweb-compression-quality">Quality: <span id="photoweb-quality-value">85</span>%</label>
                            <input type="range" id="photoweb-compression-quality" min="60" max="100" value="85" style="width: 200px; margin: 0 10px;">
                            <span class="description">Higher quality = larger file size</span>
                        </div>
                    </div>
                    <div id="photoweb-upload-preview" class="photoweb-upload-preview" style="display: none;"></div>
                </div>
                
                <div id="photoweb-upload-queue" class="photoweb-upload-queue" style="display: none;">
                    <h3>Upload Queue</h3>
                    <div id="photoweb-upload-queue-list"></div>
                </div>
                
                <div class="photoweb-form-actions">
                    <button type="submit" class="button button-primary button-large" id="photoweb-upload-btn">
                        <span class="dashicons dashicons-upload"></span> Upload Images
                    </button>
                </div>
                
                <div id="photoweb-upload-progress" class="photoweb-progress" style="display: none;">
                    <div class="photoweb-progress-bar">
                        <div class="photoweb-progress-fill" id="photoweb-progress-fill"></div>
                    </div>
                    <p class="photoweb-progress-text" id="photoweb-progress-text">Uploading...</p>
                </div>
                
                <div id="photoweb-upload-message" class="photoweb-message" style="display: none;"></div>
                
                <div id="photoweb-upload-retry" class="photoweb-upload-retry" style="display: none;">
                    <div class="photoweb-retry-info">
                        <span class="dashicons dashicons-warning"></span>
                        <span id="photoweb-retry-count">0</span> file(s) failed to upload.
                    </div>
                    <button type="button" class="button button-secondary" id="photoweb-retry-btn">
                        <span class="dashicons dashicons-update"></span> Retry Failed Uploads
                    </button>
                    <button type="button" class="button" id="photoweb-clear-failed-btn">
                        Clear Failed
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

