<?php
/**
 * Setup/Login Template
 */
?>
<div class="wrap photoweb-setup">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="photoweb-setup-container">
        <div class="photoweb-card">
            <div class="photoweb-card-header">
                <h2><span class="dashicons dashicons-admin-users"></span> Connect Your Foldious Account</h2>
                <p>Enter your Foldious email address to get started</p>
            </div>
            
            <div class="photoweb-card-body">
                <form id="photoweb-setup-form">
                    <div class="photoweb-form-group">
                        <label for="user-email">Email Address</label>
                        <input type="email" id="user-email" name="email" class="photoweb-input" placeholder="your@email.com" required>
                        <p class="description">Enter the email address associated with your Foldious account</p>
                    </div>
                    
                    <div class="photoweb-form-actions">
                        <button type="submit" class="button button-primary button-large">
                            <span class="dashicons dashicons-yes"></span> Validate & Connect
                        </button>
                    </div>
                    
                    <div id="photoweb-setup-message" class="photoweb-message" style="display: none;"></div>
                </form>
            </div>
        </div>
        
        <div class="photoweb-info-box">
            <h3><span class="dashicons dashicons-info"></span> About Foldious Plugin</h3>
            <ul>
                <li>Upload and manage images using Foldious storage</li>
                <li>Save website images as bucket</li>
                <li>Access your images from WordPress admin</li>
                <li>Organize images in folders</li>
            </ul>
        </div>
    </div>
</div>

