<?php
/**
 * Settings Template
 */
?>
<div class="wrap photoweb-settings">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <form method="post" action="options.php">
        <?php settings_fields('photoweb_settings'); ?>
        
        <div class="photoweb-card">
            <div class="photoweb-card-header">
                <h2><span class="dashicons dashicons-admin-settings"></span> Plugin Settings</h2>
            </div>
            
            <div class="photoweb-card-body">
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="photoweb_user_email">User Email</label>
                        </th>
                        <td>
                            <input type="email" id="photoweb_user_email" name="photoweb_user_email" 
                                   value="<?php echo esc_attr(get_option('photoweb_user_email', '')); ?>" 
                                   class="regular-text" readonly>
                            <p class="description">Connected Foldious account email</p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="photoweb_api_url">API URL</label>
                        </th>
                        <td>
                            <input type="url" id="photoweb_api_url" name="photoweb_api_url" 
                                   value="<?php echo esc_attr(get_option('photoweb_api_url', PHOTOWEB_API_BASE_URL)); ?>" 
                                   class="regular-text">
                            <p class="description">Foldious API base URL</p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="photoweb_auto_upload">Auto-Upload</label>
                        </th>
                        <td>
                            <label>
                                <input type="checkbox" id="photoweb_auto_upload" name="photoweb_auto_upload" value="1" <?php checked(get_option('photoweb_auto_upload', false)); ?>>
                                Auto-upload to Foldious when adding images to WordPress Media Library
                            </label>
                            <p class="description">When enabled, images uploaded to WordPress Media Library will automatically be uploaded to your Foldious account.</p>
                        </td>
                    </tr>
                </table>
                
                <div class="photoweb-form-actions">
                    <?php submit_button('Save Settings'); ?>
                    <button type="button" class="button button-secondary" id="photoweb-disconnect-btn">
                        Disconnect Account
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

