<?php
/**
 * Media Library Template for Foldious Images
 */
wp_enqueue_media();
?>
<div class="wrap">
    <h1><?php _e('Select Foldious Image', 'photoweb'); ?></h1>
    
    <div class="photoweb-card">
        <div class="photoweb-card-body">
            <div id="photoweb-media-library">
                <div class="photoweb-gallery-controls">
                    <div class="photoweb-filter-group">
                        <label for="media-folder-filter">Filter by Folder:</label>
                        <select id="media-folder-filter" class="photoweb-input">
                            <option value="">All Folders</option>
                        </select>
                    </div>
                    <div class="photoweb-search-group">
                        <input type="search" id="media-search" class="photoweb-input" placeholder="Search images...">
                    </div>
                </div>
                
                <div id="photoweb-media-gallery" class="photoweb-gallery-grid">
                    <!-- Images will be loaded here -->
                </div>
                
                <div id="photoweb-media-loader" class="photoweb-loader" style="display: none;">
                    <p>Loading images...</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    let selectedImage = null;
    
    // Load folders
    function loadFolders() {
        $.ajax({
            url: photowebData.ajaxUrl,
            type: 'POST',
            data: {
                action: 'photoweb_get_folders',
                nonce: photowebData.nonce
            },
            success: function(response) {
                if (response.success && response.data.folders) {
                    const $select = $('#media-folder-filter');
                    $select.find('option:not(:first)').remove();
                    response.data.folders.forEach(function(folder) {
                        $select.append('<option value="' + folder.folder_id + '">' + folder.folder_name + ' (' + folder.image_count + ')</option>');
                    });
                }
            }
        });
    }
    
    // Load images
    function loadImages(folderId) {
        $('#photoweb-media-loader').show();
        $('#photoweb-media-gallery').empty();
        
        $.ajax({
            url: photowebData.ajaxUrl,
            type: 'POST',
            data: {
                action: 'photoweb_get_images',
                nonce: photowebData.nonce,
                page: 1,
                folder_id: folderId || ''
            },
            success: function(response) {
                $('#photoweb-media-loader').hide();
                if (response.success && response.data.images) {
                    displayImages(response.data.images);
                }
            }
        });
    }
    
    // Display images
    function displayImages(images) {
        const $gallery = $('#photoweb-media-gallery');
        $gallery.empty();
        
        images.forEach(function(image) {
            const thumbUrl = 'https://drive.foldious.com/images.php?code=' + encodeURIComponent(image.image_code) + '&size=thumb';
            const $item = $('<div class="photoweb-gallery-item" data-code="' + image.image_code + '" data-id="' + image.image_id + '">' +
                '<img src="' + thumbUrl + '" alt="' + image.image_name + '">' +
                '<div class="photoweb-gallery-item-overlay">' +
                '<div class="photoweb-gallery-item-name">' + image.image_name + '</div>' +
                '</div>' +
                '</div>');
            
            $item.on('click', function() {
                $('.photoweb-gallery-item').removeClass('selected');
                $(this).addClass('selected');
                selectedImage = {
                    code: image.image_code,
                    id: image.image_id,
                    name: image.image_name,
                    url: 'https://drive.foldious.com/images.php?code=' + encodeURIComponent(image.image_code) + '&size=full'
                };
            });
            
            $gallery.append($item);
        });
    }
    
    // Folder filter
    $('#media-folder-filter').on('change', function() {
        loadImages($(this).val());
    });
    
    // Initialize
    loadFolders();
    loadImages();
    
    // Handle selection (this would integrate with WordPress media library)
    if (typeof send_to_editor !== 'undefined') {
        // Classic editor
        window.photowebSelectImage = function() {
            if (selectedImage) {
                const shortcode = '[foldious_image code="' + selectedImage.code + '" size="full"]';
                send_to_editor(shortcode);
                tb_remove();
            }
        };
    }
});
</script>

