<?php
/**
 * Gallery Template
 */
?>
<div class="wrap photoweb-gallery">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="photoweb-gallery-controls">
        <div class="photoweb-search-group">
            <label for="gallery-search" class="screen-reader-text">Search Images</label>
            <input type="search" id="gallery-search" class="photoweb-input" placeholder="Search images by name...">
            <span class="dashicons dashicons-search photoweb-search-icon"></span>
        </div>
        <div class="photoweb-filter-group">
            <label for="gallery-folder-filter">Filter by Folder:</label>
            <select id="gallery-folder-filter" class="photoweb-input">
                <option value="">All Folders</option>
            </select>
        </div>
        <div class="photoweb-sort-group">
            <label for="gallery-sort">Sort by:</label>
            <select id="gallery-sort" class="photoweb-input">
                <option value="date_desc">Newest First</option>
                <option value="date_asc">Oldest First</option>
                <option value="name_asc">Name (A-Z)</option>
                <option value="name_desc">Name (Z-A)</option>
                <option value="size_desc">Largest First</option>
                <option value="size_asc">Smallest First</option>
            </select>
        </div>
        <button type="button" class="button" id="photoweb-refresh-gallery">
            <span class="dashicons dashicons-update"></span> Refresh
        </button>
        <button type="button" class="button" id="photoweb-select-all-btn" style="display: none;">
            <span class="dashicons dashicons-yes-alt"></span> Select All
        </button>
    </div>
    
    <!-- Bulk Actions Bar -->
    <div id="photoweb-bulk-actions" class="photoweb-bulk-actions" style="display: none;">
        <div class="photoweb-bulk-info">
            <span class="dashicons dashicons-yes-alt"></span>
            <span id="photoweb-selected-count">0</span> image(s) selected
        </div>
        <div class="photoweb-bulk-buttons">
            <button type="button" class="button button-secondary" id="photoweb-bulk-deselect">
                <span class="dashicons dashicons-dismiss"></span> Deselect All
            </button>
            <button type="button" class="button button-primary" id="photoweb-bulk-delete">
                <span class="dashicons dashicons-trash"></span> Delete Selected
            </button>
        </div>
    </div>
    
    <div class="photoweb-info-box photoweb-url-info">
        <h3><span class="dashicons dashicons-info"></span> Image URL Sizes</h3>
        <p>You can use different image sizes in the URL by adding the <code>size</code> parameter:</p>
        <ul>
            <li><strong>Thumbnail:</strong> <code>images.php?code={image_code}&size=thumb</code></li>
            <li><strong>Medium:</strong> <code>images.php?code={image_code}&size=medium</code></li>
            <li><strong>Full Size:</strong> <code>images.php?code={image_code}&size=full</code></li>
        </ul>
        <p class="photoweb-note"><strong>Note:</strong> Click the 📋 button on any image to copy its URL. You can modify the <code>size</code> parameter to get different image sizes.</p>
    </div>
    
    <div class="photoweb-card">
        <div class="photoweb-card-body">
            <div id="photoweb-gallery-loader" class="photoweb-loader">
                <span class="spinner is-active"></span>
                <p>Loading images...</p>
            </div>
            
            <div id="photoweb-gallery-grid" class="photoweb-gallery-grid" style="display: none;"></div>
            
            <div id="photoweb-gallery-empty" class="photoweb-empty-state" style="display: none;">
                <span class="dashicons dashicons-images-alt2"></span>
                <p>No images found. <a href="<?php echo admin_url('admin.php?page=photoweb-upload'); ?>">Upload some images</a> to get started.</p>
            </div>
            
            <div id="photoweb-gallery-pagination" class="photoweb-pagination" style="display: none;"></div>
        </div>
    </div>
    
    <!-- Image Details Modal -->
    <div id="photoweb-image-modal" class="photoweb-modal" style="display: none;">
        <div class="photoweb-modal-overlay"></div>
        <div class="photoweb-modal-content">
            <div class="photoweb-modal-header">
                <h2>Image Details</h2>
                <button type="button" class="photoweb-modal-close" aria-label="Close">×</button>
            </div>
            <div class="photoweb-modal-body" id="photoweb-image-modal-body">
                <div class="photoweb-modal-loader">
                    <span class="spinner is-active"></span>
                    <p>Loading image details...</p>
                </div>
            </div>
        </div>
    </div>
</div>

