<?php
/**
 * Dashboard Template
 */
$user_email = get_option('photoweb_user_email', '');
$user_id = get_option('photoweb_user_id', '');
?>
<div class="wrap photoweb-dashboard" id="photoweb-dashboard">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="photoweb-dashboard-grid">
        <div class="photoweb-card">
            <div class="photoweb-card-header">
                <h2><span class="dashicons dashicons-admin-users"></span> Account Information</h2>
            </div>
            <div class="photoweb-card-body">
                <div class="photoweb-account-details">
                    <div class="photoweb-detail-row">
                        <span class="photoweb-detail-label">Email:</span>
                        <span class="photoweb-detail-value"><?php echo esc_html($user_email); ?></span>
                    </div>
                    <div class="photoweb-detail-row">
                        <span class="photoweb-detail-label">User ID:</span>
                        <span class="photoweb-detail-value"><?php echo esc_html($user_id); ?></span>
                    </div>
                </div>
                <div class="photoweb-dashboard-actions">
                    <a href="<?php echo admin_url('admin.php?page=photoweb-settings'); ?>" class="button">Change Account</a>
                </div>
            </div>
        </div>
        
        <div class="photoweb-card">
            <div class="photoweb-card-header">
                <h2><span class="dashicons dashicons-upload"></span> Quick Actions</h2>
            </div>
            <div class="photoweb-card-body">
                <a href="<?php echo admin_url('admin.php?page=photoweb-upload'); ?>" class="button button-primary button-large">
                    <span class="dashicons dashicons-cloud-upload"></span> Upload Images
                </a>
                <a href="<?php echo admin_url('admin.php?page=photoweb-gallery'); ?>" class="button button-large">
                    <span class="dashicons dashicons-images-alt2"></span> View Gallery
                </a>
            </div>
        </div>
    </div>
</div>

