# Foldious WordPress Plugin

A WordPress plugin to upload and manage images using Foldious storage system.

## Features

- **User Authentication**: Validate and connect Foldious account using email
- **Image Upload**: Upload multiple images with drag & drop support
- **Gallery View**: Browse and manage uploaded images
- **Folder Organization**: Organize images in folders
- **Image Management**: Delete images, copy URLs
- **Bucket Storage**: Save website images as bucket using Foldious storage

## Installation

1. Upload the `photoweb-wordpress-plugin` folder to `/wp-content/plugins/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to Foldious menu in WordPress admin
4. Enter your Foldious email address to connect your account

## Configuration

1. Navigate to **Foldious > Settings**
2. Configure API URL if needed (default: https://foldious.com/api/plugin-api)
3. Your account will be automatically connected after email validation

## Usage

### Upload Images
1. Go to **Foldious > Upload Images**
2. Select images or drag & drop
3. Choose destination folder (optional)
4. Click "Upload Images"

### View Gallery
1. Go to **Foldious > Gallery**
2. Browse your uploaded images
3. Filter by folder
4. Copy image URLs or delete images

## API Endpoints

The plugin uses the following API endpoints:
- `validate_user.php` - Validate user email
- `upload_image.php` - Upload images
- `get_images.php` - Get user images
- `delete_image.php` - Delete images
- `get_folders.php` - Get user folders

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- cURL extension enabled
- Foldious account

## Support

For support, visit https://foldious.com

