# API URL Configuration Guide

## How to Change API URL

The plugin allows you to change the API URL easily through WordPress settings:

1. Go to **Foldious > Settings** in WordPress admin
2. Update the **API URL** field
3. Click **Save Settings**

## Default API URLs

- **Production**: `https://foldious.com/api/plugin-api`
- **Localhost**: `http://localhost/extras/photoweb/api/plugin-api` (if testing locally)

## When You Upload APIs Online

When you upload your APIs to a production server:

1. **Update API URL in WordPress Settings**:
   - Go to Foldious > Settings
   - Change API URL to: `https://yourdomain.com/api/plugin-api`
   - Save settings

2. **The plugin will automatically**:
   - Use the new API URL for all requests
 - Forward uploads to `https://yourdomain.com/api/image/upload_image.php`
   - Fetch images from the new server
   - Validate users from the new database

## Important Notes

- The API URL should point to the `api/plugin-api/` folder
- Make sure all API endpoints are accessible from WordPress
- CORS headers are already set in the APIs to allow cross-origin requests
- The plugin API will automatically forward requests to the main API on the same server

## Testing

After changing the API URL:
1. Try validating a user email
2. Try uploading an image
3. Check the browser console for any errors
4. Check WordPress debug log if issues persist

